using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Linq;
using System.Linq.Expressions;

namespace PI.ZB.N1200.ELearning.WinForms.School
{
    public partial class UCSchoolList : PI.FM.N000.Base.WinForms.Controls.UCBOList<BL.BO.School, UCSchoolDetails, BL.BO.School.Search>
    {
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private PI.FM.N005.VariableRepository.BL.VariableRepository _blVariableRepository = null;

        public UCSchoolList()
        {
            InitializeComponent();
        }

        protected PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        internal PI.FM.N005.VariableRepository.BL.VariableRepository BLVariableRepository
        {
            get
            {
                if (_blVariableRepository == null)
                {
                    _blVariableRepository = new PI.FM.N005.VariableRepository.BL.VariableRepository(Environment);
                }

                return _blVariableRepository;
            }
        }

        protected override void InitAll()
        {
            base.InitAll();


            DataManager.AllowedActions = Gemini.Core.WinForms.Controls.Type.ControlActionType.Refresh | Gemini.Core.WinForms.Controls.Type.ControlActionType.RefreshCurrent | Gemini.Core.WinForms.Controls.Type.ControlActionType.Delete | Gemini.Core.WinForms.Controls.Type.ControlActionType.Save | Gemini.Core.WinForms.Controls.Type.ControlActionType.New | Gemini.Core.WinForms.Controls.Type.ControlActionType.Search;
            DataManager.InitColumns(new string[] {"ID", "Name", "Town"});//Przetumaczone
            DataManager.ColumnCaptions = new string[] {Gemini.Dictionary.Text.Grid.ID.Value, BL.Dictionary.Text.Grid.School.Name.Value, BL.Dictionary.Text.Grid.School.Town.Value };
        }

        protected override void OnSearch(Gemini.Core.WinForms.Controls.GDataManagerArgs<BL.BO.School> Args)
        {
            FSchoolSearch _fSearch = new FSchoolSearch();
            _fSearch.Initialize(Plugin, Environment);
            _fSearch.Search = DataManager.CurrentSearchCriteria;

            if (_fSearch.ShowDialog() == DialogResult.OK)
            {
                DataManager.CurrentSearchCriteria = _fSearch.Search;
                DataManager.LoadData();
            }
        }

        protected override IList<BL.BO.School> OnLoadData(Gemini.Core.WinForms.Controls.GDataManagerArgs Args)
        {
            DataManager.TotalCount = BLZSBELearning.School.Count();

            return BLZSBELearning.School.Restore(DataManager.CurrentSearchCriteria);
        }

        protected override void OnSave(Gemini.Core.WinForms.Controls.GDataManagerArgs<BL.BO.School> Args)
        {
            if (Args.Object != null)
            {
                DetailsView.Save();
                DataManager.RefreshCurrent();
            }
        }

        protected override BL.BO.School OnCreate(Gemini.Core.WinForms.Controls.GDataManagerArgs Args)
        {
            FNewSchool _dialogNew = Gemini.Core.WinForms.Base.Form.Create<FNewSchool>(Plugin, Environment);

            _dialogNew.Initialize(Plugin, Environment);

            if (_dialogNew.ShowDialog() == DialogResult.OK)
            {
                if (_dialogNew.NewSchool != null)
                {
                    return _dialogNew.NewSchool;
                }
            }
            return null;
        }

        protected override BL.BO.School DoRestoreCurrent(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
        {
            return BLZSBELearning.School.Restore(BO);
        }

        public override void DialogResultOK()
        {
            Param.Object = DataManager.Current;
            Param.ObjectTitle = DataManager.Current.Name;
            Param.ObjectID = DataManager.Current.ID;
            Param.IsObjectValid = true;
            Param.ClientID = BLZSBELearning.ClientID;
            Param.ObjectList = DataManager.GetSelectedObjects().Select(x => (FM.N000.Base.BL.BO.Base)x).ToList();
        }
    }
}
